VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form frmClan 
   BackColor       =   &H00000000&
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Clan Manager"
   ClientHeight    =   4860
   ClientLeft      =   45
   ClientTop       =   360
   ClientWidth     =   5715
   BeginProperty Font 
      Name            =   "Tahoma"
      Size            =   8.25
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H00FFFFFF&
   Icon            =   "frmClan.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4860
   ScaleWidth      =   5715
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame fraMOTD 
      Appearance      =   0  'Flat
      BackColor       =   &H00000000&
      Caption         =   "Message of the Day"
      ForeColor       =   &H00FFFFFF&
      Height          =   855
      Left            =   120
      TabIndex        =   8
      Top             =   5040
      Width           =   5415
      Begin VB.TextBox txtMOTD 
         BackColor       =   &H00000000&
         ForeColor       =   &H00FFFFFF&
         Height          =   285
         Left            =   120
         TabIndex        =   10
         Text            =   "Text1"
         Top             =   330
         Width           =   4335
      End
      Begin VB.Line Line24 
         BorderColor     =   &H00FFFFFF&
         X1              =   4680
         X2              =   5280
         Y1              =   240
         Y2              =   240
      End
      Begin VB.Line Line23 
         BorderColor     =   &H00FFFFFF&
         X1              =   4680
         X2              =   5280
         Y1              =   600
         Y2              =   600
      End
      Begin VB.Line Line22 
         BorderColor     =   &H00FFFFFF&
         X1              =   4680
         X2              =   4680
         Y1              =   240
         Y2              =   600
      End
      Begin VB.Line Line21 
         BorderColor     =   &H00FFFFFF&
         X1              =   5280
         X2              =   5280
         Y1              =   240
         Y2              =   600
      End
      Begin VB.Label cmdSetMOTD 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         Caption         =   "Set"
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H00FFFFFF&
         Height          =   255
         Left            =   4680
         TabIndex        =   9
         Top             =   330
         Width           =   615
      End
   End
   Begin MSComctlLib.ListView lvMembers 
      Height          =   3615
      Left            =   120
      TabIndex        =   5
      Top             =   600
      Width           =   3975
      _ExtentX        =   7011
      _ExtentY        =   6376
      View            =   3
      LabelWrap       =   -1  'True
      HideSelection   =   -1  'True
      HideColumnHeaders=   -1  'True
      _Version        =   393217
      SmallIcons      =   "ilRanks"
      ForeColor       =   16777215
      BackColor       =   0
      Appearance      =   0
      NumItems        =   2
      BeginProperty ColumnHeader(1) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
         Text            =   "Rank / Username"
         Object.Width           =   4939
      EndProperty
      BeginProperty ColumnHeader(2) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
         SubItemIndex    =   1
         Text            =   "Status"
         Object.Width           =   1852
      EndProperty
   End
   Begin MSComctlLib.ImageList ilRanks 
      Left            =   5160
      Top             =   0
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      ImageWidth      =   41
      ImageHeight     =   24
      MaskColor       =   12632256
      _Version        =   393216
      BeginProperty Images {2C247F25-8591-11D1-B16A-00C0F0283628} 
         NumListImages   =   4
         BeginProperty ListImage1 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmClan.frx":000C
            Key             =   ""
         EndProperty
         BeginProperty ListImage2 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmClan.frx":0A0B
            Key             =   ""
         EndProperty
         BeginProperty ListImage3 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmClan.frx":141F
            Key             =   ""
         EndProperty
         BeginProperty ListImage4 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmClan.frx":1E39
            Key             =   ""
         EndProperty
      EndProperty
   End
   Begin VB.Label cmdAutomation 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Automation..."
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   255
      Left            =   4200
      TabIndex        =   12
      Top             =   3930
      Width           =   1455
   End
   Begin VB.Line Line28 
      BorderColor     =   &H00FFFFFF&
      X1              =   5640
      X2              =   5640
      Y1              =   3840
      Y2              =   4200
   End
   Begin VB.Line Line27 
      BorderColor     =   &H00FFFFFF&
      X1              =   4200
      X2              =   4200
      Y1              =   3840
      Y2              =   4200
   End
   Begin VB.Line Line26 
      BorderColor     =   &H00FFFFFF&
      X1              =   4200
      X2              =   5640
      Y1              =   4200
      Y2              =   4200
   End
   Begin VB.Line Line25 
      BorderColor     =   &H00FFFFFF&
      X1              =   4200
      X2              =   5640
      Y1              =   3840
      Y2              =   3840
   End
   Begin VB.Label lblNotInClan 
      BackColor       =   &H00000000&
      Caption         =   "You are not a member of any clan.  Press Create to begin the process of creating a new one."
      ForeColor       =   &H00FFFFFF&
      Height          =   855
      Left            =   120
      TabIndex        =   11
      Top             =   600
      Visible         =   0   'False
      Width           =   3735
   End
   Begin VB.Line Line4 
      BorderColor     =   &H00FFFFFF&
      X1              =   4200
      X2              =   5640
      Y1              =   2640
      Y2              =   2640
   End
   Begin VB.Line Line3 
      BorderColor     =   &H00FFFFFF&
      X1              =   4200
      X2              =   5640
      Y1              =   3000
      Y2              =   3000
   End
   Begin VB.Line Line2 
      BorderColor     =   &H00FFFFFF&
      X1              =   4200
      X2              =   4200
      Y1              =   2640
      Y2              =   3000
   End
   Begin VB.Line Line1 
      BorderColor     =   &H00FFFFFF&
      X1              =   5640
      X2              =   5640
      Y1              =   2640
      Y2              =   3000
   End
   Begin VB.Label cmdMOTD 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Change MOTD"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   255
      Left            =   4200
      TabIndex        =   7
      Top             =   2730
      Width           =   1455
   End
   Begin VB.Label lblStatus 
      BackColor       =   &H00000000&
      ForeColor       =   &H00FFFFFF&
      Height          =   255
      Left            =   120
      TabIndex        =   6
      Top             =   4560
      Width           =   5415
   End
   Begin VB.Label cmdDemote 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Demote"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   255
      Left            =   4200
      TabIndex        =   4
      Top             =   2130
      Width           =   1455
   End
   Begin VB.Line Line20 
      BorderColor     =   &H00FFFFFF&
      X1              =   5640
      X2              =   5640
      Y1              =   2040
      Y2              =   2400
   End
   Begin VB.Line Line19 
      BorderColor     =   &H00FFFFFF&
      X1              =   4200
      X2              =   4200
      Y1              =   2040
      Y2              =   2400
   End
   Begin VB.Line Line18 
      BorderColor     =   &H00FFFFFF&
      X1              =   4200
      X2              =   5640
      Y1              =   2400
      Y2              =   2400
   End
   Begin VB.Line Line17 
      BorderColor     =   &H00FFFFFF&
      X1              =   4200
      X2              =   5640
      Y1              =   2040
      Y2              =   2040
   End
   Begin VB.Label cmdPromote 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Promote"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   255
      Left            =   4200
      TabIndex        =   3
      Top             =   1650
      Width           =   1455
   End
   Begin VB.Line Line16 
      BorderColor     =   &H00FFFFFF&
      X1              =   5640
      X2              =   5640
      Y1              =   1560
      Y2              =   1920
   End
   Begin VB.Line Line15 
      BorderColor     =   &H00FFFFFF&
      X1              =   4200
      X2              =   4200
      Y1              =   1560
      Y2              =   1920
   End
   Begin VB.Line Line14 
      BorderColor     =   &H00FFFFFF&
      X1              =   4200
      X2              =   5640
      Y1              =   1920
      Y2              =   1920
   End
   Begin VB.Line Line13 
      BorderColor     =   &H00FFFFFF&
      X1              =   4200
      X2              =   5640
      Y1              =   1560
      Y2              =   1560
   End
   Begin VB.Label cmdRemove 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Remove"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   255
      Left            =   4200
      TabIndex        =   2
      Top             =   930
      Width           =   1455
   End
   Begin VB.Line Line12 
      BorderColor     =   &H00FFFFFF&
      X1              =   5640
      X2              =   5640
      Y1              =   840
      Y2              =   1200
   End
   Begin VB.Line Line11 
      BorderColor     =   &H00FFFFFF&
      X1              =   4200
      X2              =   4200
      Y1              =   840
      Y2              =   1200
   End
   Begin VB.Line Line10 
      BorderColor     =   &H00FFFFFF&
      X1              =   4200
      X2              =   5640
      Y1              =   1200
      Y2              =   1200
   End
   Begin VB.Line Line9 
      BorderColor     =   &H00FFFFFF&
      X1              =   4200
      X2              =   5640
      Y1              =   840
      Y2              =   840
   End
   Begin VB.Label cmdInvite 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Invite..."
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   255
      Left            =   4200
      TabIndex        =   1
      Top             =   450
      Width           =   1455
   End
   Begin VB.Line Line8 
      BorderColor     =   &H00FFFFFF&
      X1              =   5640
      X2              =   5640
      Y1              =   360
      Y2              =   720
   End
   Begin VB.Line Line7 
      BorderColor     =   &H00FFFFFF&
      X1              =   4200
      X2              =   4200
      Y1              =   360
      Y2              =   720
   End
   Begin VB.Line Line6 
      BorderColor     =   &H00FFFFFF&
      X1              =   4200
      X2              =   5640
      Y1              =   720
      Y2              =   720
   End
   Begin VB.Line Line5 
      BorderColor     =   &H00FFFFFF&
      X1              =   4200
      X2              =   5640
      Y1              =   360
      Y2              =   360
   End
   Begin VB.Label lblClanMembers 
      BackColor       =   &H00000000&
      Caption         =   "Clan Members"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   2295
   End
End
Attribute VB_Name = "frmClan"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private ClanExists As Boolean

Private Enum RankIcons
    iconPeon = 1
    iconGrunt = 2
    iconShaman = 3
    iconChieftain = 4
End Enum

Private Sub cmdAutomation_Click()
    If (cmdAutomation.ForeColor = vbSilver) Then
        Exit Sub
    End If
    
    frmAutoClan.Show
End Sub

Private Sub cmdInvite_Click()
    Dim User As String
    
    If (Not ClanExists) Then
        Load frmCreateClan
        frmCreateClan.Show
        Me.Hide
        Unload Me
        Exit Sub
    End If
    
    If cmdInvite.ForeColor = vbSilver Then Exit Sub
    
    User = InputBox("Please enter the name of the user that you wish to invite:", _
        "Invite User to Clan", "")
    If LenB(User) = 0 Then Exit Sub
    
    UserClan.Invite User, asManager
    lblStatus = "Inviting user " + User + ", please wait..."
End Sub

Private Sub cmdRemove_Click()
    If (cmdRemove.ForeColor = vbSilver) Then Exit Sub
    If (lvMembers.SelectedItem Is Nothing) Then Exit Sub
    lblStatus = "Removing user " + lvMembers.SelectedItem.Text + ", please wait..."
    DoEvents
    If (UserClan.Remove(lvMembers.SelectedItem.Text, asManager) = False) Then
        lblStatus = "Error: Failed to generate removal request.  Please report this bug."
    End If
End Sub

Private Sub cmdPromote_Click()
On Error GoTo P_Error
    Dim Member As ClanMember
    Dim Res As VbMsgBoxResult
    
    If (cmdPromote.ForeColor = vbSilver) Then Exit Sub
    If (lvMembers.SelectedItem Is Nothing) Then Exit Sub
    
    Set Member = UserClan.GetMember(lvMembers.SelectedItem.Text)
    If (Member.Rank = rankShaman) Then
        Res = MsgBox("WARNING!  You are about to promote a shaman, which will REMOVE YOUR CHIEFTAIN STATUS.  " & _
            "Are you SURE that you want to do this?", vbYesNo Or vbCritical Or vbDefaultButton2, "Change Clan Chieftain")
        If (Res <> vbYes) Then Exit Sub
    End If
    
    lblStatus = "Promoting user " + Member.Username + ", please wait..."
    DoEvents
    If (UserClan.Promote(lvMembers.SelectedItem.Text, asManager) = False) Then
        lblStatus = "Error: Failed to generate promotion request.  Please report this bug."
    End If
    Exit Sub:
P_Error:
    MsgBox "Synchronization error.  Please report this bug, and what you were doing when it happened.", vbExclamation, _
        GetVersion()
End Sub

Private Sub cmdDemote_Click()
    If (cmdDemote.ForeColor = vbSilver) Then Exit Sub
    If (lvMembers.SelectedItem Is Nothing) Then Exit Sub
    lblStatus = "Demoting user " + lvMembers.SelectedItem.Text + ", please wait..."
    DoEvents
    If (UserClan.Demote(lvMembers.SelectedItem.Text, asManager) = False) Then
        lblStatus = "Error: Failed to generate demotion request.  Please report this bug."
    End If
End Sub

Private Sub cmdMOTD_Click()
    If UserClan.Rank < rankShaman Then
        MsgBox "You must be a shaman or higher to change the clan MOTD.", vbExclamation, _
            "Permission Denied"
        Exit Sub
    End If
    Height = 6585
    txtMOTD.Text = UserClan.MOTD
    fraMOTD.Visible = True
End Sub

Private Sub cmdSetMOTD_Click()
    UserClan.SetMOTD txtMOTD.Text
    UserClan.RequestMOTD
    Height = 5340
    fraMOTD.Visible = False
    lblStatus.Caption = "Message of the day was changed."
End Sub

Private Sub Form_Load()
    Dim MOTD As String
    
    If (Not BuildList()) Then
        lblStatus = "You are currently not a member of any clan."
        cmdInvite.Caption = "Create..."
        ClanExists = False
        lblNotInClan.Visible = True
        lvMembers.Visible = False
    Else
        clanWindowOpen = True
        cmdInvite.Caption = "Invite..."
        ClanExists = True
    End If
    
    Height = 5340
    fraMOTD.Visible = False
    
    lblStatus.Caption = ""
    MOTD = UserClan.MOTD
    If (LenB(MOTD) > 0) Then _
        lblStatus.Caption = "MOTD: " + MOTD
End Sub

Public Sub ListChanged()
    BuildList
End Sub

Private Function BuildList() As Boolean
    Dim Members() As ClanMember
    Dim i As Long
    Dim Icon As RankIcons
    Dim LastSelect As String
    Dim NewItem As ListItem
    
    If (Not UserClan.Active) Then
        BuildList = False
        cmdRemove.ForeColor = vbSilver
        cmdPromote.ForeColor = vbSilver
        cmdDemote.ForeColor = vbSilver
        cmdMOTD.ForeColor = vbSilver
        cmdAutomation.ForeColor = vbSilver
        Exit Function
    End If
    
    If (Not UserClan.GetMembers(Members)) Then
        MsgBox "Failed to load member data.  Please report this bug.", vbExclamation
        BuildList = False
        Exit Function
    End If
    
    BuildList = True
    
    CheckPermissions
    
    SortMembers Members
    
    If (Not (lvMembers.SelectedItem Is Nothing)) Then
        LastSelect = lvMembers.SelectedItem.Text
    Else
        LastSelect = vbNullString
    End If
    lvMembers.ListItems.Clear
    
    For i = LBound(Members) To UBound(Members)
        Select Case Members(i).Rank
            Case rankNewPeon, rankPeon: Icon = iconPeon
            Case rankGrunt: Icon = iconGrunt
            Case rankShaman: Icon = iconShaman
            Case rankChieftain: Icon = iconChieftain
        End Select
        Set NewItem = lvMembers.ListItems.Add(, Members(i).Username, Members(i).Username, , Icon)
        If (Members(i).Username = LastSelect) Then _
            lvMembers.SelectedItem = NewItem
        With NewItem
            .ToolTipText = Members(i).Username & " (" & Members(i).RankName & ")"
            If (Members(i).Online) Then
                .SubItems(1) = "Online"
                .ListSubItems(1).ForeColor = vbGreen
            Else
                .SubItems(1) = "Offline"
                .ListSubItems(1).ForeColor = vbRed
            End If
        End With
    Next i
End Function

Private Sub CheckPermissions()
    Dim ButtonColor As Long
    Dim Member As ClanMember
    
    If UserClan.Rank < rankShaman Then
        cmdInvite.ForeColor = vbSilver
        cmdRemove.ForeColor = vbSilver
        cmdPromote.ForeColor = vbSilver
        cmdDemote.ForeColor = vbSilver
        cmdMOTD.ForeColor = vbSilver
    Else
        cmdInvite.ForeColor = vbWhite
        cmdMOTD.ForeColor = vbWhite
        If (lvMembers.SelectedItem Is Nothing) Then
            cmdRemove.ForeColor = vbSilver
            cmdPromote.ForeColor = vbSilver
            cmdDemote.ForeColor = vbSilver
        Else
            Set Member = UserClan.GetMember(lvMembers.SelectedItem.Text)
            cmdRemove.ForeColor = vbSilver
            cmdPromote.ForeColor = vbSilver
            cmdDemote.ForeColor = vbSilver
            If (Member Is Nothing) Then
                MsgBox "Clan member list and internal tracking appear to be out of sync!", vbExclamation, GetVersion()
            Else
                Select Case Member.Rank
                    Case rankPeon
                        cmdRemove.ForeColor = vbWhite
                        cmdPromote.ForeColor = vbWhite
                    Case rankGrunt
                        cmdDemote.ForeColor = vbWhite
                        cmdRemove.ForeColor = vbWhite
                        If (UserClan.Rank = rankChieftain) Then _
                            cmdPromote.ForeColor = vbWhite
                    Case rankShaman
                        If (UserClan.Rank = rankChieftain) Then
                            cmdRemove.ForeColor = vbWhite
                            cmdPromote.ForeColor = vbWhite
                            cmdDemote.ForeColor = vbWhite
                        End If
                End Select
            End If
        End If
                    
    End If
    
End Sub

Public Sub InvitationResponse(Username As String, ByVal Status As InvitationStatus)
    Dim Message As String
    Select Case Status
        Case isAccepted
            Message = Username & " accepted the invitation."
            BuildList
        Case isDeclined
            Message = Username & " declined the invitation."
        Case isFailed
            Message = "Failed to invite " & Username & " to the clan."
        Case isClanFull
            Message = "Failed to invite " & Username & ": The clan is full."
        Case Else
            Message = "Failed to invite " & Username & ": " & UserClan.StatusString(Status)
    End Select
    
    lblStatus.Caption = Message
End Sub

Public Sub RemovalResponse(Username As String, ByVal Status As ActionStatus)
    If (Status = asSuccess) Then
        lblStatus.Caption = Username & " was successfully removed."
        BuildList
    Else
        lblStatus.Caption = "Failed to remove " + Username + ": " + UserClan.StatusString(Status)
    End If
End Sub

Public Sub PromotionResponse(Username As String, ByVal Status As ActionStatus)
    If (Status = asSuccess) Then
        lblStatus.Caption = Username & " was successfully promoted."
        BuildList
    Else
        lblStatus.Caption = "Failed to promote " + Username + ": " + UserClan.StatusString(Status)
    End If
End Sub

Public Sub DemotionResponse(Username As String, ByVal Status As ActionStatus)
    If (Status = asSuccess) Then
        lblStatus.Caption = Username & " was successfully demoted."
        BuildList
    Else
        lblStatus.Caption = "Failed to demote " + Username + ": " + UserClan.StatusString(Status)
    End If
End Sub

'SortMembers() implements Quicksort.
Private Sub SortMembers(Members() As ClanMember, Optional ByVal Lower As Long = -1, _
    Optional ByVal Upper As Long = -1)
    
    Dim Pivot As ClanMember, L As Long, R As Long
    
    If Lower < 0 Then _
        Lower = LBound(Members)
    If Upper < 0 Then _
        Upper = UBound(Members)
        
    ' ------
    
    If Upper > Lower + 1 Then
        
        Set Pivot = Members(Lower)
        L = Lower + 1
        R = Upper
        
        Do While (L < R)
            If Pivot.CompareTo(Members(L)) <= 0 Then
                L = L + 1
            Else
                R = R - 1
                CMSwap Members, L, R
            End If
        Loop
        
        L = L - 1
        CMSwap Members, L, Lower
        SortMembers Members, Lower, L
        SortMembers Members, R, Upper
    End If
End Sub

Private Sub CMSwap(Members() As ClanMember, i As Long, j As Long)
    Dim Temp As ClanMember
    Set Temp = Members(i)
    Set Members(i) = Members(j)
    Set Members(j) = Temp
End Sub

Private Sub Form_Unload(Cancel As Integer)
    clanWindowOpen = False
End Sub

Private Sub lvMembers_ItemClick(ByVal Item As MSComctlLib.ListItem)
    CheckPermissions
End Sub
